CREATE OR ALTER FUNCTION [dbo].[ObfuscateField] (@Prefix NVARCHAR(100), @Value NVARCHAR(MAX), @Id INT, @DataType INT = 1)
RETURNS NVARCHAR(100)
BEGIN
	--String
	IF(@DataType = 1)
	BEGIN
		RETURN 
		CASE 
			WHEN @Value IS NULL THEN NULL
			WHEN @Value = '' THEN ''
			ELSE CONCAT(@Prefix, '_', @Id)
		END
	END

	--Email
	IF(@DataType = 2)
	BEGIN
		RETURN 
		CASE 
			WHEN @Value IS NULL THEN NULL
			WHEN @Value = '' THEN ''
			ELSE CONCAT(@Id , '@', @Prefix, '.pl')
		END
	END

	--Phone
	IF(@DataType = 3)
	BEGIN
		RETURN 
		CASE 
			WHEN @Value IS NULL THEN NULL
			WHEN @Value = '' THEN ''
			ELSE CONCAT(@Id, '24-678-675')
		END
	END

	--ZipCode
	IF(@DataType = 4)
	BEGIN
		RETURN 
		CASE 
			WHEN @Value IS NULL THEN NULL
			WHEN @Value = '' THEN ''
			ELSE CONCAT(LEFT(CONCAT(@Id, '00'), 2), '-', LEFT(CONCAT(@Id, '000'), 3))
		END
	END

	--Money
	IF(@DataType = 5)
	BEGIN
		RETURN 
		CASE 
			WHEN @Value IS NULL THEN NULL
			WHEN @Value = '' THEN ''
			ELSE CAST(CONCAT(@Id, '.', '99') AS DECIMAL(12,2))
		END
	END

	RETURN NULL
END
GO




--Customers
UPDATE 
	[AlpolWMS].[Customer]
SET
	[Code] = [dbo].[ObfuscateField]('Code',[Code], Id, default),
	[Name1] = [dbo].[ObfuscateField]('Name1',[Name1], Id, default),
	[Name2] = [dbo].[ObfuscateField]('Name2',[Name2], Id, default),
	[Name3] = [dbo].[ObfuscateField]('Name3', [Name3], Id, default),
	[Description] = [dbo].[ObfuscateField]('Description', [Description], Id, default)


--Articles
UPDATE 
	[AlpolWMS].[Article]
SET
	[Code] = [dbo].[ObfuscateField]('Code',[Code], Id, default),
	[Name] = [dbo].[ObfuscateField]('Name',[Name], Id, default)


--Shipment
UPDATE
	[AlpolWMS].[DocumentStorageShipment]
SET
	[DocumentAmount] = [dbo].[ObfuscateField](null, [DocumentAmount], Id, 5),
	[DocumentAmountEUR] = [dbo].[ObfuscateField](null, [DocumentAmountEUR], Id, 5),
	[Email] = [dbo].[ObfuscateField]('futuritiwms',[Email], Id, 2),
	[Name1] = [dbo].[ObfuscateField]('Name1',[Name1], Id, default),
	[Name2] = [dbo].[ObfuscateField]('Name2',[Name2], Id, default),
	[ContactFirstName] = [dbo].[ObfuscateField]('FirstName',[ContactFirstName], Id, default),
	[ContactLastName] = [dbo].[ObfuscateField]('LastName',[ContactLastName], Id, default),
	[VatNumber] = [dbo].[ObfuscateField]('XY',[VatNumber], Id, default),
	[PhoneNumber1] = [dbo].[ObfuscateField](null ,[PhoneNumber1], Id, 3),
	[PhoneNumber2] = [dbo].[ObfuscateField](null ,[PhoneNumber2], Id, 3),
	[ZipCode] = [dbo].[ObfuscateField](null ,[ZipCode], Id, 4),
	[Street1] = [dbo].[ObfuscateField]('Street1' ,[Street1], Id, default),
	[Street2] = [dbo].[ObfuscateField]('Street2' ,[Street2], Id, default),
	[City] = [dbo].[ObfuscateField]('City' ,[City], Id, default),
	[OrderDescription] = [dbo].[ObfuscateField]('OrderDescription' ,[OrderDescription], Id, default),
	[DeliveryValue] = [dbo].[ObfuscateField](null, [DeliveryValue], Id, 5),
	[DeliveryValueEUR] = [dbo].[ObfuscateField](null, [DeliveryValueEUR], Id, 5)

--Users
UPDATE
	[AlpolWMS].[User]
SET
	[Name] = [dbo].[ObfuscateField]('Name' ,[Name] , Id, default),
	[Surname] = [dbo].[ObfuscateField]('Surname' ,[Surname], Id, default)

--UserSessions
UPDATE
	[AlpolWMS].[UserSession]
SET
	[WindowsIdentity] = [dbo].[ObfuscateField]('WindowsIdentity' ,[WindowsIdentity] , Id, default),
	[UserLogin] = [dbo].[ObfuscateField]('UserLogin' ,[UserLogin], Id, default)

--Shipment: Accounts
UPDATE
	[AlpolShipment].[Accounts]
SET
	[Login] = [dbo].[ObfuscateField]('Login' ,[Login] , Id, default),
	[Password] = [dbo].[ObfuscateField]('Password' ,[Password] , Id, default),
	[ApiKey] = [dbo].[ObfuscateField]('ApiKey' ,[ApiKey] , Id, default),
	[MasterFid] = [dbo].[ObfuscateField]('MasterFid' ,[MasterFid] , Id, default)

--Shipment: CourierDataAllegroOne
UPDATE
	[AlpolShipment].[CourierDataAllegroOne]
SET
	[ReceiverStreet] = [dbo].[ObfuscateField]('ReceiverStreet' ,[ReceiverStreet] , Id, default),
	[ReceiverPostCode] = [dbo].[ObfuscateField](null ,[ReceiverPostCode], Id, 4),
	[ReceiverCity] = [dbo].[ObfuscateField]('ReceiverCity' ,[ReceiverCity] , Id, default),
	[ReceiverEmail] = [dbo].[ObfuscateField]('futuritiwms',[ReceiverEmail], Id, 2),
	[ReceiverName] = [dbo].[ObfuscateField]('ReceiverName' ,[ReceiverName] , Id, default),
	[ReceiverCompany] = [dbo].[ObfuscateField]('ReceiverCompany' ,[ReceiverCompany] , Id, default),
	[ReceiverPhone] = [dbo].[ObfuscateField](null ,[ReceiverPhone], Id, 3),
	[PickupStreet] = [dbo].[ObfuscateField]('PickupStreet' ,[PickupStreet] , Id, default),
	[PickupPostCode] = [dbo].[ObfuscateField](null ,[PickupPostCode], Id, 4),
	[PickupCity] = [dbo].[ObfuscateField]('PickupCity' ,[PickupCity] , Id, default),
	[PickupEmail] = [dbo].[ObfuscateField]('futuritiwms',[PickupEmail], Id, 2),
	[PickupName] = [dbo].[ObfuscateField]('PickupName' ,[PickupName] , Id, default),
	[PickupCompany] = [dbo].[ObfuscateField]('PickupCompany' ,[PickupCompany] , Id, default),
	[PickupPhone] = [dbo].[ObfuscateField](null ,[PickupPhone], Id, 3),
	[SenderStreet] = [dbo].[ObfuscateField]('SenderStreet' ,[SenderStreet] , Id, default),
	[SenderCity] = [dbo].[ObfuscateField]('SenderCity' ,[SenderCity] , Id, default),
	[SenderEmail] = [dbo].[ObfuscateField]('futuritiwms',[SenderEmail], Id, 2),
	[SenderName] = [dbo].[ObfuscateField]('SenderName' ,[SenderName] , Id, default),
	[SenderCompany] = [dbo].[ObfuscateField]('SenderCompany' ,[SenderCompany] , Id, default),
	[SenderPhone] = [dbo].[ObfuscateField](null ,[SenderPhone], Id, 3)

--Shipment: CourierDataAllegroOne_Parcel
UPDATE
	[AlpolShipment].[CourierDataAllegroOne_Parcel]
SET
	[Amount] = [dbo].[ObfuscateField](null, [Amount], Id, 5)

--Shipment: CourierDataDHL
UPDATE
 [AlpolShipment].[CourierDataDHL]
SET
	[City] = [dbo].[ObfuscateField]('City' ,[City] , Id, default),
	[Comment] = [dbo].[ObfuscateField]('Comment' ,[Comment] , Id, default),
	[ContactEmail] = [dbo].[ObfuscateField]('futuritiwms',[ContactEmail], Id, 2),
	[ContactPerson] = [dbo].[ObfuscateField]('ContactEmail' ,[ContactEmail] , Id, default),
	[ContactPhone] = [dbo].[ObfuscateField](null ,[ContactPhone], Id, 3),
	[PostalCode] = [dbo].[ObfuscateField](null ,[PostalCode], Id, 4),
	[Product] = [dbo].[ObfuscateField]('Product' ,[Product] , Id, default),
	[ReturnOnDeliveryReference] = [dbo].[ObfuscateField]('ReturnOnDeliveryReference' ,[ReturnOnDeliveryReference] , Id, default),
	[Street] = [dbo].[ObfuscateField]('Street' ,[Street] , Id, default),
	[Name] = [dbo].[ObfuscateField]('Name' ,[Name] , Id, default)

--Shipment: CourierDataDPD
UPDATE
	[AlpolShipment].[CourierDataDPD]
SET
	[Address] = [dbo].[ObfuscateField]('Address' ,[Address] , Id, default),
	[City] = [dbo].[ObfuscateField]('City' ,[City] , Id, default),
	[Company] = [dbo].[ObfuscateField]('Company' ,[Company] , Id, default),
	[Email] = [dbo].[ObfuscateField]('futuritiwms', [Email], Id, 2),
	[Name] = [dbo].[ObfuscateField]('Name' ,[Name] , Id, default),
	[Phone] = [dbo].[ObfuscateField](null ,[Phone], Id, 3),
	[PostalCode] = [dbo].[ObfuscateField](null ,[PostalCode], Id, 4),
	[DutyServiceAmount] = [dbo].[ObfuscateField](null, [DutyServiceAmount], Id, 5)

--Shipment: CourierDataDPD_DE
UPDATE
	[AlpolShipment].[CourierDataDPD_DE]
SET
	[ReciverName1] = [dbo].[ObfuscateField]('ReciverName1' ,[ReciverName1] , Id, default),
	[ReciverName2] = [dbo].[ObfuscateField]('ReciverName2' ,[ReciverName2] , Id, default),
	[ReciverStreet] = [dbo].[ObfuscateField]('ReciverStreet' ,[ReciverStreet] , Id, default),
	[ReciverState] = [dbo].[ObfuscateField]('ReciverState' ,[ReciverState] , Id, default),
	[ReciverZipCode] = [dbo].[ObfuscateField](null ,[ReciverZipCode], Id, 4),
	[ReciverCity] = [dbo].[ObfuscateField]('ReciverCity' ,[ReciverCity] , Id, default),
	[ReciverCustomerNumber] = [dbo].[ObfuscateField]('ReciverCustomerNumber' ,[ReciverCustomerNumber] , Id, default),
	[ReciverContact] = [dbo].[ObfuscateField]('ReciverContact', [ReciverContact] , Id, default),
	[ReciverPhone] = [dbo].[ObfuscateField](null ,[ReciverPhone], Id, 3),
	[ReciverFax] = [dbo].[ObfuscateField]('ReciverFax' ,[ReciverFax] , Id, default),
	[ReciverEmail] = [dbo].[ObfuscateField]('futuritiwms', [ReciverEmail], Id, 2),
	[ReciverComment] = [dbo].[ObfuscateField]('ReciverComment' ,[ReciverComment] , Id, default),
	[Product] = [dbo].[ObfuscateField]('Product' ,[Product] , Id, default),
	[ThirdPartyFID_PL] = [dbo].[ObfuscateField]('ThirdPartyFID_PL' ,[ThirdPartyFID_PL] , Id, default)



--Shipment: CourierDataEuropaczka
UPDATE
	[AlpolShipment].[CourierDataEuropaczka]
SET
	[City] = [dbo].[ObfuscateField]('City' ,[City] , Id, default),
	[Email]= [dbo].[ObfuscateField]('futuritiwms', [Email], Id, 2),
	[Fax] = [dbo].[ObfuscateField]('Fax' ,[Fax] , Id, default),
	[Name1] = [dbo].[ObfuscateField]('Name1' ,[Name1] , Id, default),
	[Name2] = [dbo].[ObfuscateField]('Name2' ,[Name2] , Id, default),
	[Name3] = [dbo].[ObfuscateField]('Name3' ,[Name3] , Id, default),
	[PostCode] = [dbo].[ObfuscateField](null ,[PostCode], Id, 4),
	[Street] = [dbo].[ObfuscateField]('Street' ,[Street] , Id, default),
	[Telephone] = [dbo].[ObfuscateField](null ,[Telephone], Id, 3)

--Shipment: CourierDataFedEx
UPDATE
	[AlpolShipment].[CourierDataFedEx]
SET
	[Street] = [dbo].[ObfuscateField]('Street' ,[Street] , Id, default),	
	[City] = [dbo].[ObfuscateField]('City' ,[City] , Id, default),
	[Company] = [dbo].[ObfuscateField]('Company' ,[Company] , Id, default),
	[Email] = [dbo].[ObfuscateField]('futuritiwms', [Email], Id, 2),
	[Name] = [dbo].[ObfuscateField]('Name' ,[Name] , Id, default),
	[Surname] = [dbo].[ObfuscateField]('Surname' ,[Surname] , Id, default),
	[Phone] = [dbo].[ObfuscateField](null ,[Phone], Id, 3),
	[PostalCode] = [dbo].[ObfuscateField](null ,[PostalCode], Id, 4),
	[BankAccountNumber] = [dbo].[ObfuscateField]('BankAccountNumber' ,[BankAccountNumber] , Id, default)


--Shipment: CourierDataFedexInternational
UPDATE
	[AlpolShipment].[CourierDataFedexInternational]
SET
	[ReciverCompanyName]  = [dbo].[ObfuscateField]('ReciverCompanyName' ,[ReciverCompanyName] , Id, default),	
	[ReciverEMailAddress] = [dbo].[ObfuscateField]('futuritiwms', [ReciverEMailAddress], Id, 2),
	[ReciverPhoneNumber] = [dbo].[ObfuscateField](null ,[ReciverPhoneNumber], Id, 3),
	[ReciverCity]  = [dbo].[ObfuscateField]('ReciverCity' ,[ReciverCity] , Id, default),	
	[ReciverPostalCode] = [dbo].[ObfuscateField](null ,[ReciverPostalCode], Id, 4),
	[ReciverStreetLine1]  = [dbo].[ObfuscateField]('ReciverStreetLine1' ,[ReciverStreetLine1] , Id, default),	
	[ReciverStreetLines2]  = [dbo].[ObfuscateField]('ReciverStreetLines2' ,[ReciverStreetLines2] , Id, default),	
	[ReciverPersonName]  = [dbo].[ObfuscateField]('ReciverPersonName' ,[ReciverPersonName] , Id, default),	
	[SenderCompanyName]  = [dbo].[ObfuscateField]('SenderCompanyName' ,[SenderCompanyName] , Id, default),	
	[SenderEMailAddress] = [dbo].[ObfuscateField]('futuritiwms', [ReciverEMailAddress], Id, 2),
	[SenderPhoneNumber] = [dbo].[ObfuscateField](null, [SenderPhoneNumber], Id, 3),
	[SenderCity]  = [dbo].[ObfuscateField]('SenderCity' ,[SenderCity] , Id, default),	
	[SenderPostalCode] = [dbo].[ObfuscateField](null ,[SenderPostalCode], Id, 4),
	[SenderStreetLine1]  = [dbo].[ObfuscateField]('SenderStreetLine1' ,[SenderStreetLine1] , Id, default),	
	[SenderStreetLines2]  = [dbo].[ObfuscateField]('SenderStreetLines2' ,[SenderStreetLines2] , Id, default),	
	[SenderPersonName]  = [dbo].[ObfuscateField]('SenderPersonName' ,[SenderPersonName] , Id, default),	
	[CustomerReference]  = [dbo].[ObfuscateField]('CustomerReference' ,[CustomerReference] , Id, default),	
	[ItemDescription]  = [dbo].[ObfuscateField]('ItemDescription' ,[ItemDescription] , Id, default),	
	[ItemDescriptionForClearance]  = [dbo].[ObfuscateField]('ItemDescriptionForClearance' ,[ItemDescriptionForClearance] , Id, default)



--Shipment: CourierDataFedexInternational_Parcel
UPDATE
	[AlpolShipment].[CourierDataFedexInternational_Parcel]
SET
	[Name] = [dbo].[ObfuscateField]('Name' ,[Name], Id, default),	
	[PriceAmount] = [dbo].[ObfuscateField](null, [PriceAmount], Id, 5),
	[Description] = [dbo].[ObfuscateField]('Description' ,[Description], Id, default)


--Shipment: CourierDataGLS_CZ
UPDATE
	[AlpolShipment].[CourierDataGLS_CZ]
SET
	[Content] = [dbo].[ObfuscateField]('Content' ,[Content], Id, default),
	[Consig_name] = [dbo].[ObfuscateField]('Consig_name' ,[Consig_name], Id, default),
	[Consig_address] = [dbo].[ObfuscateField]('Consig_address' ,[Consig_address], Id, default),
	[Consig_zipcode] = [dbo].[ObfuscateField](null ,[Consig_zipcode], Id, 4),
	[Consig_city] = [dbo].[ObfuscateField]('Consig_city' ,[Consig_city], Id, default),
	[Consig_contact] = [dbo].[ObfuscateField]('Consig_contact' ,[Consig_contact], Id, default),
	[Consig_phone] = [dbo].[ObfuscateField](null ,[Consig_phone], Id, 3),
	[Consig_email]  = [dbo].[ObfuscateField]('futuritiwms', [Consig_email], Id, 2)


--Shipment: CourierDataGLS_HU
UPDATE
	[AlpolShipment].[CourierDataGLS_HU]
SET
	[Content] = [dbo].[ObfuscateField]('Content' ,[Content], Id, default),
	[Consig_name] = [dbo].[ObfuscateField]('Consig_name' ,[Consig_name], Id, default),
	[Consig_address] = [dbo].[ObfuscateField]('Consig_address' ,[Consig_address], Id, default),
	[Consig_zipcode] = [dbo].[ObfuscateField](null ,[Consig_zipcode], Id, 4),
	[Consig_city] = [dbo].[ObfuscateField]('Consig_city' ,[Consig_city], Id, default),
	[Consig_contact] = [dbo].[ObfuscateField]('Consig_contact' ,[Consig_contact], Id, default),
	[Consig_phone] = [dbo].[ObfuscateField](null ,[Consig_phone], Id, 3),
	[Consig_email]  = [dbo].[ObfuscateField]('futuritiwms', [Consig_email], Id, 2)


--Shipment: CourierDataGLS_RO
UPDATE
	[AlpolShipment].[CourierDataGLS_RO]
SET
	[Content] = [dbo].[ObfuscateField]('Content' ,[Content], Id, default),
	[Consig_name] = [dbo].[ObfuscateField]('Consig_name' ,[Consig_name], Id, default),
	[Consig_address] = [dbo].[ObfuscateField]('Consig_address' ,[Consig_address], Id, default),
	[Consig_zipcode] = [dbo].[ObfuscateField](null ,[Consig_zipcode], Id, 4),
	[Consig_city] = [dbo].[ObfuscateField]('Consig_city' ,[Consig_city], Id, default),
	[Consig_contact] = [dbo].[ObfuscateField]('Consig_contact' ,[Consig_contact], Id, default),
	[Consig_phone] = [dbo].[ObfuscateField](null ,[Consig_phone], Id, 3),
	[Consig_email]  = [dbo].[ObfuscateField]('futuritiwms', [Consig_email], Id, 2)


--Shipment: CourierDataGLS_SK
UPDATE
	[AlpolShipment].[CourierDataGLS_SK]
SET
	[Content] = [dbo].[ObfuscateField]('Content' ,[Content], Id, default),
	[Consig_name] = [dbo].[ObfuscateField]('Consig_name' ,[Consig_name], Id, default),
	[Consig_address] = [dbo].[ObfuscateField]('Consig_address' ,[Consig_address], Id, default),
	[Consig_zipcode] = [dbo].[ObfuscateField](null ,[Consig_zipcode], Id, 4),
	[Consig_city] = [dbo].[ObfuscateField]('Consig_city' ,[Consig_city], Id, default),
	[Consig_contact] = [dbo].[ObfuscateField]('Consig_contact' ,[Consig_contact], Id, default),
	[Consig_phone] = [dbo].[ObfuscateField](null ,[Consig_phone], Id, 3),
	[Consig_email]  = [dbo].[ObfuscateField]('futuritiwms', [Consig_email], Id, 2)


--Shipment: CourierDataGLS_PL
UPDATE
	[AlpolShipment].[CourierDataGLS_PL]
SET
	[Consig_name1] = [dbo].[ObfuscateField]('Consig_name1' ,[Consig_name1], Id, default),
	[Consig_name2] = [dbo].[ObfuscateField]('Consig_name2' ,[Consig_name2], Id, default),
	[Consig_name3] = [dbo].[ObfuscateField]('Consig_name3' ,[Consig_name3], Id, default),
	[Consig_contact] = [dbo].[ObfuscateField]('Consig_contact' ,[Consig_contact], Id, default),
	[Consig_phone] = [dbo].[ObfuscateField](null ,[Consig_phone], Id, 3),
	[Consig_street] = [dbo].[ObfuscateField]('Consig_street' ,[Consig_street], Id, default),
	[Consig_city] = [dbo].[ObfuscateField]('Consig_city' ,[Consig_city], Id, default),
	[Notes] = [dbo].[ObfuscateField]('Notes' ,[Notes], Id, default),
	[Consig_zipcode] = [dbo].[ObfuscateField](null ,[Consig_zipcode], Id, 4),
	[dawName] = [dbo].[ObfuscateField]('dawName' ,[dawName], Id, default),
	[dawPhone] = [dbo].[ObfuscateField](null ,[dawPhone], Id, 3),
	[PPEsname1] = [dbo].[ObfuscateField]('PPEsname1' ,[PPEsname1], Id, default),
	[PPEsname2] = [dbo].[ObfuscateField]('PPEsname2' ,[PPEsname2], Id, default),
	[PPEsname3] = [dbo].[ObfuscateField]('PPEsname3' ,[PPEsname3], Id, default),
	[PPEszipcode] = [dbo].[ObfuscateField](null ,[PPEszipcode], Id, 4),
	[PPEscity] = [dbo].[ObfuscateField]('PPEscity' ,[PPEscity], Id, default),
	[PPEsstreet] = [dbo].[ObfuscateField]('PPEsstreet' ,[PPEsstreet], Id, default),
	[PPEsphone] = [dbo].[ObfuscateField](null ,[PPEsphone], Id, 3),
	[PPEscontact] = [dbo].[ObfuscateField]('PPEscontact' ,[PPEscontact], Id, default),
	[PPErname1] = [dbo].[ObfuscateField]('PPErname1' ,[PPErname1], Id, default),
	[PPErname2] = [dbo].[ObfuscateField]('PPErname2' ,[PPErname2], Id, default),
	[PPErname3] = [dbo].[ObfuscateField]('PPErname3' ,[PPErname3], Id, default),
	[PPErzipcode] = [dbo].[ObfuscateField](null ,[PPErzipcode], Id, 4),
	[PPErcity] = [dbo].[ObfuscateField]('PPErcity' ,[PPErcity], Id, default),
	[PPErstreet] = [dbo].[ObfuscateField]('PPErstreet' ,[PPErstreet], Id, default),
	[PPErphone] = [dbo].[ObfuscateField](null ,[PPErphone], Id, 3),
	[PPErcontact] = [dbo].[ObfuscateField]('PPErcontact' ,[PPErcontact], Id, default),
	[PPEreferences] = [dbo].[ObfuscateField]('PPEreferences' ,[PPEreferences], Id, default)


--Shipment: CourierDataGoGlobal
UPDATE
	[AlpolShipment].[CourierDataGoGlobal]
SET
	[AdditionalDescription] = [dbo].[ObfuscateField]('AdditionalDescription' ,[AdditionalDescription], Id, default),
	[Address1] = [dbo].[ObfuscateField]('Address1' ,[Address1], Id, default),
	[Address2] = [dbo].[ObfuscateField]('Address2' ,[Address2], Id, default),
	[City] = [dbo].[ObfuscateField]('City' ,[City], Id, default),
	[Email]  = [dbo].[ObfuscateField]('futuritiwms', [Email], Id, 2),
	[NameOrCompany] = [dbo].[ObfuscateField]('NameOrCompany' ,[NameOrCompany], Id, default),
	[TaxId] = [dbo].[ObfuscateField]('TaxId' ,[TaxId], Id, default),
	[ZipCode] = [dbo].[ObfuscateField](null ,[ZipCode], Id, 4)


--Shipment: CourierDataInpostPaczkomaty
UPDATE
	[AlpolShipment].[CourierDataInpostPaczkomaty]
SET
	[City] = [dbo].[ObfuscateField]('City' ,[City], Id, default),
	[CompanyName] = [dbo].[ObfuscateField]('CompanyName' ,[CompanyName], Id, default),
	[Email]= [dbo].[ObfuscateField]('futuritiwms', [Email], Id, 2),
	[FirstName] = [dbo].[ObfuscateField]('FirstName' ,[FirstName], Id, default),
	[LastName] = [dbo].[ObfuscateField]('LastName' ,[LastName], Id, default),
	[Phone] = [dbo].[ObfuscateField](null ,[Phone], Id, 3),
	[PostCode] = [dbo].[ObfuscateField](null ,[PostCode], Id, 4),
	[ReciverName] = [dbo].[ObfuscateField]('ReciverName' ,[ReciverName], Id, default),
	[Street] = [dbo].[ObfuscateField]('Street' ,[Street], Id, default),
	[TargetPoint] = [dbo].[ObfuscateField]('TargetPoint' ,[TargetPoint], Id, default),
	[DropoffPoint] = [dbo].[ObfuscateField]('DropoffPoint' ,[DropoffPoint], Id, default)



--Shipment: CourierDataKex
UPDATE
	[AlpolShipment].[CourierDataKex]
SET
	[O_Nazwa] = [dbo].[ObfuscateField]('O_Nazwa' ,[O_Nazwa], Id, default),
	[O_Ulica] = [dbo].[ObfuscateField]('O_Ulica' ,[O_Ulica], Id, default),
	[O_Miejscowosc] = [dbo].[ObfuscateField]('O_Miejscowosc' ,[O_Miejscowosc], Id, default),
	[O_Kod_Pocztowy] = [dbo].[ObfuscateField](null ,[O_Kod_Pocztowy], Id, 4),
	[O_Tel_Gsm] = [dbo].[ObfuscateField](null ,[O_Tel_Gsm], Id, 3),
	[O_Email] = [dbo].[ObfuscateField]('futuritiwms', [O_Email], Id, 2),
	[U_Rach_Pobrania] = [dbo].[ObfuscateField]('U_Rach_Pobrania' ,[U_Rach_Pobrania], Id, default),
	[Uwagi] = [dbo].[ObfuscateField]('Uwagi' ,[Uwagi], Id, default),
	[Opis] = [dbo].[ObfuscateField]('Opis' ,[Opis], Id, default),
	[Cargo_Description] = [dbo].[ObfuscateField]('Cargo_Description' ,[Cargo_Description], Id, default)


--Shipment: CourierDataMeest
UPDATE
	[AlpolShipment].[CourierDataMeest]
SET
	[deliveryNumber] = [dbo].[ObfuscateField]('deliveryNumber' ,[deliveryNumber], Id, default),
	[recipientName] = [dbo].[ObfuscateField]('recipientName' ,[recipientName], Id, default),
	[recipientCityIdRef] = [dbo].[ObfuscateField]('recipientCityIdRef' ,[recipientCityIdRef], Id, default),
	[recipientCity] = [dbo].[ObfuscateField]('recipientCity' ,[recipientCity], Id, default),
	[recipientStreet] = [dbo].[ObfuscateField]('recipientStreet' ,[recipientStreet], Id, default),
	[recipientStreetWithHouseNumber] = [dbo].[ObfuscateField]('recipientStreetWithHouseNumber' ,[recipientStreetWithHouseNumber], Id, default),
	[recipientStreetIdRef] = [dbo].[ObfuscateField]('recipientStreetIdRef' ,[recipientStreetIdRef], Id, default),
	[recipientPostCode]= [dbo].[ObfuscateField](null ,[recipientPostCode], Id, 4),
	[recipientPostOffice] = [dbo].[ObfuscateField]('recipientPostOffice' ,[recipientPostOffice], Id, default),
	[recipientProvince] = [dbo].[ObfuscateField]('recipientProvince' ,[recipientPostOffice], Id, default),
	[recipientPhone] = [dbo].[ObfuscateField](null ,[recipientPhone], Id, 3),
	[recipientEmail] = [dbo].[ObfuscateField]('futuritiwms', [recipientEmail], Id, 2),
	[recipientNotice] = [dbo].[ObfuscateField]('recipientNotice' ,[recipientNotice], Id, default),
	[deliveryName] = [dbo].[ObfuscateField]('deliveryName' ,[deliveryName], Id, default),
	[deliveryCityIdRef] = [dbo].[ObfuscateField]('deliveryCityIdRef' ,[deliveryCityIdRef], Id, default),
	[deliveryCity] = [dbo].[ObfuscateField]('deliveryCity' ,[deliveryCity], Id, default),
	[deliveryStreetWithHouseNumber] = [dbo].[ObfuscateField]('deliveryStreetWithHouseNumber' ,[deliveryStreetWithHouseNumber], Id, default),
	[deliveryStreetIdRef] = [dbo].[ObfuscateField]('deliveryStreetIdRef' ,[deliveryStreetIdRef], Id, default),
	[deliveryPostCode]= [dbo].[ObfuscateField](null ,[deliveryPostCode], Id, 4),
	[deliveryPostOffice] = [dbo].[ObfuscateField]('deliveryPostOffice' ,[deliveryPostOffice], Id, default),
	[deliveryProvince] = [dbo].[ObfuscateField]('deliveryProvince' ,[deliveryProvince], Id, default),
	[deliveryDistrict] = [dbo].[ObfuscateField]('deliveryDistrict' ,[deliveryDistrict], Id, default),
	[deliveryPhone] = [dbo].[ObfuscateField](null ,[deliveryPhone], Id, 3),
	[deliveryEmail] = [dbo].[ObfuscateField]('futuritiwms', [deliveryEmail], Id, 2),
	[deliveryNotice] = [dbo].[ObfuscateField]('deliveryNotice' ,[deliveryNotice], Id, default),
	[value] = [dbo].[ObfuscateField](null, [value], Id, 5),
	[summaCodEur] = [dbo].[ObfuscateField](null, [summaCodEur], Id, 5),
	[summaCodUah] = [dbo].[ObfuscateField](null, [summaCodUah], Id, 5),
	[receiverName] = [dbo].[ObfuscateField]('receiverName' ,[receiverName], Id, default),
	[note] = [dbo].[ObfuscateField]('note' ,[note], Id, default),
	[receiverEmail] = [dbo].[ObfuscateField]('futuritiwms', [receiverEmail], Id, 2),
	[deliveryCostEur] = [dbo].[ObfuscateField](null, [deliveryCostEur], Id, 5),
	[deliveryCostUah] = [dbo].[ObfuscateField](null, [deliveryCostUah], Id, 5),
	[senderName] = [dbo].[ObfuscateField]('senderName' ,[senderName], Id, default),
	[senderStreetWithHouseNumber] = [dbo].[ObfuscateField]('senderStreetWithHouseNumber' ,[senderStreetWithHouseNumber], Id, default),
	[senderStreetIdRef] = [dbo].[ObfuscateField]('senderStreetIdRef' ,[senderStreetIdRef], Id, default),
	[senderPostCode] = [dbo].[ObfuscateField](null ,[senderPostCode], Id, 4),
	[senderPostOffice] = [dbo].[ObfuscateField]('senderPostOffice' ,[senderPostOffice], Id, default),
	[senderProvince] = [dbo].[ObfuscateField]('senderProvince' ,[senderProvince], Id, default),
	[senderDistrict] = [dbo].[ObfuscateField]('senderDistrict' ,[senderDistrict], Id, default),
	[senderPhone] = [dbo].[ObfuscateField](null ,[senderPhone], Id, 3),
	[senderEmail] = [dbo].[ObfuscateField]('futuritiwms', [senderEmail], Id, 2),
	[senderNotice] = [dbo].[ObfuscateField]('senderNotice' ,[senderNotice], Id, default),
	[contentsType] = [dbo].[ObfuscateField]('contentsType' ,[contentsType], Id, default),
	[targetPoint] = [dbo].[ObfuscateField]('targetPoint' ,[targetPoint], Id, default)



--Shipment: CourierDataMeest_Parcel
UPDATE
	[AlpolShipment].[CourierDataMeest_Parcel]
SET
	[name] = [dbo].[ObfuscateField]('name' ,[name], Id, default),
	[nameUk] = [dbo].[ObfuscateField]('nameUk' ,[nameUk], Id, default),
	[value] = [dbo].[ObfuscateField](null, [value], Id, 5),
	[valueUah] = [dbo].[ObfuscateField](null, [valueUah], Id, 5)


--Shipment: CourierDataOlza
UPDATE
	[AlpolShipment].[CourierDataOlza]
SET
	[ReferenceNumber] = [dbo].[ObfuscateField]('ReferenceNumber' ,[ReferenceNumber], Id, default),
	[SenderName] = [dbo].[ObfuscateField]('SenderName' ,[SenderName], Id, default),
	[SenderAddress] = [dbo].[ObfuscateField]('SenderAddress' ,[SenderAddress], Id, default),
	[SenderCity] = [dbo].[ObfuscateField]('SenderCity' ,[SenderCity], Id, default),
	[SenderZipcode] = [dbo].[ObfuscateField](null ,[SenderZipcode], Id, 4),
	[SenderContactPerson] = [dbo].[ObfuscateField]('SenderContactPerson' ,[SenderContactPerson], Id, default),
	[SenderEmail] = [dbo].[ObfuscateField]('futuritiwms', [SenderEmail], Id, 2),
	[SenderPhone] = [dbo].[ObfuscateField](null ,[SenderPhone], Id, 3),
	[RecipientFirstname] = [dbo].[ObfuscateField]('RecipientFirstname' ,[RecipientFirstname], Id, default),
	[RecipientSurname] = [dbo].[ObfuscateField]('RecipientSurname' ,[RecipientSurname], Id, default),
	[RecipientAddress] = [dbo].[ObfuscateField]('RecipientAddress' ,[RecipientAddress], Id, default),
	[RecipientCity] = [dbo].[ObfuscateField]('RecipientCity' ,[RecipientCity], Id, default),
	[RecipientZipcode] = [dbo].[ObfuscateField](null ,[RecipientZipcode], Id, 4),
	[RecipientContactPerson] = [dbo].[ObfuscateField]('RecipientContactPerson' ,[RecipientContactPerson], Id, default),
	[RecipientEmail] = [dbo].[ObfuscateField]('futuritiwms', [SenderEmail], Id, 2),
	[RecipientPhone] = [dbo].[ObfuscateField](null ,[RecipientPhone], Id, 3),
	[PickupPlaceId] = [dbo].[ObfuscateField]('PickupPlaceId' ,[PickupPlaceId], Id, default),
	[CodAmount] = [dbo].[ObfuscateField](null, [CodAmount], Id, 5),
	[ShipmentDescription] = [dbo].[ObfuscateField]('ShipmentDescription' ,[ShipmentDescription], Id, default)



--Shipment: CourierDataOmnisell
UPDATE
	[AlpolShipment].[CourierDataOmnisell]
SET
	[ReferenceNumber] = [dbo].[ObfuscateField]('ReferenceNumber' ,[ReferenceNumber], Id, default),
	[Street] = [dbo].[ObfuscateField]('Street' ,[Street], Id, default),
	[District] = [dbo].[ObfuscateField]('District' ,[District], Id, default),
	[City] = [dbo].[ObfuscateField]('[City' ,[City], Id, default),
	[ZipCode] = [dbo].[ObfuscateField](null ,[ZipCode], Id, 4),
	[Note] = [dbo].[ObfuscateField]('Note' ,[Note], Id, default),
	[Email] = [dbo].[ObfuscateField]('futuritiwms', [Email], Id, 2),
	[Phone] = [dbo].[ObfuscateField](null ,[Phone], Id, 3),
	[ContactName] = [dbo].[ObfuscateField]('ContactName' ,[ContactName], Id, default),
	[FirstName] = [dbo].[ObfuscateField]('FirstName' ,[FirstName], Id, default),
	[MiddleName] = [dbo].[ObfuscateField]('MiddleName' ,[MiddleName], Id, default),
	[LastName] = [dbo].[ObfuscateField]('LastName' ,[LastName], Id, default),
	[Company] = [dbo].[ObfuscateField]('Company' ,[Company], Id, default)
			


--Shipment: CourierDataPaczkaWRuchu
UPDATE
	[AlpolShipment].[CourierDataPaczkaWRuchu]
SET
	[DestinationCode] = [dbo].[ObfuscateField]('DCode' ,[DestinationCode], Id, default),
	[AlternativeDestinationCode] = [dbo].[ObfuscateField]('ADCode' ,[AlternativeDestinationCode], Id, default),
	[Name] = [dbo].[ObfuscateField]('Name' ,[Name], Id, default),
	[Email] = [dbo].[ObfuscateField]('futuritiwms', [Email], Id, 2),
	[PhoneNumber] = [dbo].[ObfuscateField](null ,[PhoneNumber], Id, 3)



--Shipment: CourierDataPocztaPolska
UPDATE
	[AlpolShipment].[CourierDataPocztaPolska]
SET
	[Email] = [dbo].[ObfuscateField]('futuritiwms', [Email], Id, 2),
	[KodPocztowy] = [dbo].[ObfuscateField](null ,[KodPocztowy], Id, 4),
	[Miejscowosc] = [dbo].[ObfuscateField]('Miejscowosc]' , [Miejscowosc], Id, default),
	[Mobile] = [dbo].[ObfuscateField](null ,[Mobile], Id, 3),
	[Nazwa] = [dbo].[ObfuscateField]('Nazwa' ,[Nazwa], Id, default),
	[Nazwa2] = [dbo].[ObfuscateField]('Nazwa2' ,[Nazwa2], Id, default),
	[Nip] = [dbo].[ObfuscateField]('XY' ,[Nip], Id, default),
	[NumerReferencyjnyCelny] = [dbo].[ObfuscateField]('NumerReferencyjnyCelny' ,[NumerReferencyjnyCelny], Id, default),
	[OsobaKontaktowa] = [dbo].[ObfuscateField]('OsobaKontaktowa' ,[OsobaKontaktowa], Id, default),
	[Telefon] = [dbo].[ObfuscateField](null ,[Telefon], Id, 3),
	[Tytulem] = [dbo].[ObfuscateField]('Tytulem' ,[Tytulem], Id, default),
	[Ulica] = [dbo].[ObfuscateField]('Ulica' ,[Ulica], Id, default),
	[Zawartosc] = [dbo].[ObfuscateField]('Zawartosc' ,[Zawartosc], Id, default),
	[PointOfDelivery] = [dbo].[ObfuscateField]('PointOfDelivery' ,[PointOfDelivery], Id, default),
	[AllegroId] = [dbo].[ObfuscateField]('AllegroId' ,[AllegroId], Id, default),
	[PointOfPosting] = [dbo].[ObfuscateField]('PointOfPosting' ,[PointOfPosting], Id, default)



--Shipment: CourierDataSwiatPrzesylek
UPDATE
	[AlpolShipment].[CourierDataSwiatPrzesylek]
SET
	[value]  = [dbo].[ObfuscateField](null, [value], Id, 5),
	[company] = [dbo].[ObfuscateField]('company' ,[company], Id, default),
	[address_line_1] = [dbo].[ObfuscateField]('addrln1' ,[address_line_1], Id, default),
	[address_line_2] = [dbo].[ObfuscateField]('addln2' ,[address_line_2], Id, default),
	[city] = [dbo].[ObfuscateField]('city' ,[city], Id, default),
	[zip_code] = [dbo].[ObfuscateField](null ,[zip_code], Id, 4),
	[tel] = [dbo].[ObfuscateField](null ,[tel], Id, 3),
	[email] = [dbo].[ObfuscateField]('futuritiwms', [email], Id, 2),
	[name] = [dbo].[ObfuscateField]('name' ,[name], Id, default),
	[cod_bank_account] = [dbo].[ObfuscateField]('cod_bank_account' ,[cod_bank_account], Id, default),
	[additions] = [dbo].[ObfuscateField]('additions' ,[additions], Id, default)



--Shipment: CourierDataUPS
UPDATE
	[AlpolShipment].[CourierDataUPS]
SET
	[ShipperAddressLine1] = [dbo].[ObfuscateField]('ShipperAddressLine1' ,[ShipperAddressLine1], Id, default),
	[ShipperAddressLine2] = [dbo].[ObfuscateField]('ShipperAddressLine2' ,[ShipperAddressLine2], Id, default),
	[ShipperAddressLine3] = [dbo].[ObfuscateField]('ShipperAddressLine3' ,[ShipperAddressLine3], Id, default),
	[ShipperCity] = [dbo].[ObfuscateField]('ShipperCity' ,[ShipperCity], Id, default),
	[ShipperStateProvinceCode] = [dbo].[ObfuscateField]('ShipperStateProvinceCode' ,[ShipperStateProvinceCode], Id, default),
	[ShipperPostalCode] = [dbo].[ObfuscateField](null ,[ShipperPostalCode], Id, 4),
	[ShipperName] = [dbo].[ObfuscateField]('ShipperName' ,[ShipperName], Id, default),
	[ShipperAttentionName] = [dbo].[ObfuscateField]('ShipperAttentionName' ,[ShipperAttentionName], Id, default),
	[ShipperCompanyDisplayableName] = [dbo].[ObfuscateField]('ShipperCompanyDisplayableName' ,[ShipperCompanyDisplayableName], Id, default),
	[ShipperTaxIdentificationNumber] = [dbo].[ObfuscateField]('ShipperTaxIdentificationNumber' ,[ShipperTaxIdentificationNumber], Id, default),
	[ShipperEMailAddress] = [dbo].[ObfuscateField]('futuritiwms', [ShipperEMailAddress], Id, 2),
	[ShipperPhoneNumber] = [dbo].[ObfuscateField](null ,[ShipperPhoneNumber], Id, 3),
	[ShipperFaxNumber] = [dbo].[ObfuscateField]('ShipperFaxNumber' ,[ShipperFaxNumber], Id, default),
	[ReciverAddressLine1] = [dbo].[ObfuscateField]('ReciverAddressLine1' ,[ReciverAddressLine1], Id, default),
	[ReciverAddressLine2] = [dbo].[ObfuscateField]('ReciverAddressLine2' ,[ReciverAddressLine2], Id, default),
	[ReciverAddressLine3] = [dbo].[ObfuscateField]('ReciverAddressLine3' ,[ReciverAddressLine3], Id, default),
	[ReciverCity] = [dbo].[ObfuscateField]('ReciverCity' ,[ReciverCity], Id, default),
	[ReciverStateProvinceCode] = [dbo].[ObfuscateField]('ReciverStateProvinceCode' ,[ReciverStateProvinceCode], Id, default),
	[ReciverPostalCode] = [dbo].[ObfuscateField](null ,[ReciverPostalCode], Id, 4),
	[ReciverName] = [dbo].[ObfuscateField]('ReciverName' ,[ReciverName], Id, default),
	[ReciverAttentionName] = [dbo].[ObfuscateField]('ReciverAttentionName' ,[ReciverAttentionName], Id, default),
	[ReciverCompanyDisplayableName] = [dbo].[ObfuscateField]('ReciverCompanyDisplayableName' ,[ReciverCompanyDisplayableName], Id, default),
	[ReciverTaxIdentificationNumber] = [dbo].[ObfuscateField]('XY' ,[ReciverFaxNumber], Id, default),
	[ReciverEMailAddress] = [dbo].[ObfuscateField]('futuritiwms', [ReciverEMailAddress], Id, 2),
	[ReciverPhoneNumber] = [dbo].[ObfuscateField](null ,[ShipperPhoneNumber], Id, 3),
	[ReciverFaxNumber] = [dbo].[ObfuscateField]('ReciverFaxNumber' ,[ReciverFaxNumber], Id, default),
	[AlternateAddressAddressLine1] = [dbo].[ObfuscateField]('AlternateAddressAddressLine1' ,[AlternateAddressAddressLine1], Id, default),
	[AlternateAddressAddressLine2] = [dbo].[ObfuscateField]('AlternateAddressAddressLine2' ,[AlternateAddressAddressLine2], Id, default),
	[AlternateAddressAddressLine3] = [dbo].[ObfuscateField]('AlternateAddressAddressLine3' ,[AlternateAddressAddressLine3], Id, default),
	[AlternateAddressCity] = [dbo].[ObfuscateField]('AlternateAddressCity' ,[AlternateAddressCity], Id, default),
	[AlternateAddressStateProvinceCode] = [dbo].[ObfuscateField]('AlternateAddressStateProvinceCode' ,[AlternateAddressStateProvinceCode], Id, default),
	[AlternateAddressPostalCode] = [dbo].[ObfuscateField](null ,[AlternateAddressPostalCode], Id, 4),
	[AlternateAddressName] = [dbo].[ObfuscateField]('AlternateAddressName' ,[AlternateAddressName], Id, default),
	[AlternateAddressAttentionName] = [dbo].[ObfuscateField]('AlternateAddressAttentionName' ,[AlternateAddressAttentionName], Id, default),
	[Description] = [dbo].[ObfuscateField]('Description' ,[Description], Id, default),
	[AlternateAddressUPSAccessPointID] = [dbo].[ObfuscateField]('AlternateAddressUPSAccessPointID' ,[AlternateAddressUPSAccessPointID], Id, default),
	[InvoiceComments] = [dbo].[ObfuscateField]('InvoiceComments' ,[InvoiceComments], Id, default),
	[FreightCharges] = [dbo].[ObfuscateField](null, [FreightCharges], Id, 5)


--Shipment: CourierDataUPS_InvoiceProduct
UPDATE
	[AlpolShipment].[CourierDataUPS_InvoiceProduct]
SET
	[Description] = [dbo].[ObfuscateField]('Description' ,[Description], Id, default),
	[ProductPrice] = [dbo].[ObfuscateField](null, [ProductPrice], Id, 5),
	[CommodityCode] = [dbo].[ObfuscateField]('CommodityCode' ,[CommodityCode], Id, default)



--Shipment: CourierDataUPS_Parcel
UPDATE
	[AlpolShipment].[CourierDataUPS_Parcel]
SET
	[Description] = [dbo].[ObfuscateField]('Description' ,[Description], Id, default),
	[ReferenceNumber1] = [dbo].[ObfuscateField]('ReferenceNumber1' ,[ReferenceNumber1], Id, default),
	[ReferenceNumber2] = [dbo].[ObfuscateField]('ReferenceNumber2' ,[ReferenceNumber2], Id, default),
	[DeclaredValueMonetaryValue] = CAST([dbo].[ObfuscateField](null, [DeclaredValueMonetaryValue], Id, 5) AS NVARCHAR(12))



--Shipment: PackageHeader
UPDATE
	[AlpolShipment].[PackageHeader]
SET
	[InsuranceAmount] = [dbo].[ObfuscateField](null, [InsuranceAmount], Id, 5),
	[CodAmount] = [dbo].[ObfuscateField](null, [CodAmount], Id, 5),
	[Description] = [dbo].[ObfuscateField]('Description' ,[Description], Id, default),
	[References] = [dbo].[ObfuscateField]('References' ,[References], Id, default),
	[Content] = [dbo].[ObfuscateField]('Content' ,[Content], Id, default),
	[OrderDescription] = [dbo].[ObfuscateField]('OrderDescription' ,[OrderDescription], Id, default),
	[DocumentAmount] = [dbo].[ObfuscateField](null, [DocumentAmount], Id, 5)



--AlpolWF: EmailAccounts
UPDATE
	[AlpolWF].[EmailAccounts]
SET
	[RedirectAllEmailsTo] = [dbo].[ObfuscateField]('futuritiwms', [RedirectAllEmailsTo], Id, 2),
	[SmtpServer] = [dbo].[ObfuscateField]('SmtpServer' ,[SmtpServer], Id, default),
	[SmtpUsername] = [dbo].[ObfuscateField]('SmtpUsername' ,[SmtpUsername], Id, default),
	[SmtpPassword] = [dbo].[ObfuscateField]('SmtpPassword' ,[SmtpPassword], Id, default),
	[EmailFrom] = [dbo].[ObfuscateField]('EmailFrom', [EmailFrom], Id, 2),
	[Name] = [dbo].[ObfuscateField]('Name' ,[Name], Id, default)



--AlpolWF: FTPAccounts
UPDATE
	[AlpolWF].[FTPAccounts]
SET
	[Name] = [dbo].[ObfuscateField]('Name' ,[Name], Id, default),
	[Login] = [dbo].[ObfuscateField]('Login' ,[Login], Id, default),
	[Password] = [dbo].[ObfuscateField]('Password' ,[Password], Id, default),
	[PasswordEnc] = [dbo].[ObfuscateField]('PasswordEnc' ,[PasswordEnc], Id, default),
	[Server] = [dbo].[ObfuscateField]('Server' ,[Server], Id, default)



GO
DROP FUNCTION [dbo].[ObfuscateField]

GO